
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:55:30 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HASH_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  CRYS_ATP_TST_HASH_Acceptance_test_vectors.c         
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for HASH Acceptance tests                             
 *
 **************************/


/***** Include Files ******/
#include "CRYS_ATP_TST_HASH_Acceptance.h"
#if TST_USE_HASH_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines ***********/
/******** Enums ***********/
/******** Typedefs **********/
/******** Global Data *********/
/***** Private function prototype *********/
/******** Public Functions ********/
/******** Private Functions *******/
TST_HASH_TestDataStruct TST_HASH_Acceptance_TestData[] =
{
        /**************/
        /*        HASH SHA1/MD5 vectors         */
        /**************/
#if TST_USE_HASH_0BYTE_DATA
	{ 
		{"Acceptance test x.0 - HASH/0ByteData "},
			/*TST_input_data*/
		{""},
		/*TST_input_dataSize*/
		0*sizeof(DxUint8_t),
		/*TST_HashResultBuff*/
		{0},
		/*TST_SHA1_Expected_output_data*/
		{0xda,0x39,0xa3,0xee,0x5e,0x6b,0x4b,0x0d,0x32,0x55,0xbf,0xef,0x95,0x60,0x18,0x90,
		0xaf,0xd8,0x07,0x09}, 
		/*TST_SAH1_expected_dataSize*/
		CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
		/*TST_MD5_Expected_output_data*/
		{0xd4,0x1d,0x8c,0xd9,0x8f,0x00,0xb2,0x04,0xe9,0x80,0x09,0x98,0xec,0xf8,0x42,0x7e}, 
		/*TST_MD5_Expeced_dataSize*/
		CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),       
		/*TST_SHA224_Expected_output_data*/
		{0xd1,0x4a,0x02,0x8c,0x2a,0x3a,0x2b,0xc9,0x47,0x61,0x02,0xbb,0x28,0x82,0x34,0xc4,
		0x15,0xa2,0xb0,0x1f,0x82,0x8e,0xa6,0x2a,0xc5,0xb3,0xe4,0x2f}, 
		/*TST_SHA224_Expeced_dataSize*/
		CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
		/*TST_SHA256_Expected_output_data*/
		{0xe3,0xb0,0xc4,0x42,0x98,0xfc,0x1c,0x14,0x9a,0xfb,0xf4,0xc8,0x99,0x6f,0xb9,0x24,
		0x27,0xae,0x41,0xe4,0x64,0x9b,0x93,0x4c,0xa4,0x95,0x99,0x1b,0x78,0x52,0xb8,0x55}, 
		/*TST_SHA256_Expeced_dataSize*/
		CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
		/*TST_SHA384_Expected_output_data*/
		{0x38,0xb0,0x60,0xa7,0x51,0xac,0x96,0x38,0x4c,0xd9,0x32,0x7e,0xb1,0xb1,0xe3,0x6a,
		0x21,0xfd,0xb7,0x11,0x14,0xbe,0x07,0x43,0x4c,0x0c,0xc7,0xbf,0x63,0xf6,0xe1,0xda,
		0x27,0x4e,0xde,0xbf,0xe7,0x6f,0x65,0xfb,0xd5,0x1a,0xd2,0xf1,0x48,0x98,0xb9,0x5b}, 
		/*TST_SHA384_Expeced_dataSize*/
		CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
		/*TST_SHA512_Expected_output_data*/
		{0xcf,0x83,0xe1,0x35,0x7e,0xef,0xb8,0xbd,0xf1,0x54,0x28,0x50,0xd6,0x6d,0x80,0x07,
		0xd6,0x20,0xe4,0x05,0x0b,0x57,0x15,0xdc,0x83,0xf4,0xa9,0x21,0xd3,0x6c,0xe9,0xce,
		0x47,0xd0,0xd1,0x3c,0x5d,0x85,0xf2,0xb0,0xff,0x83,0x18,0xd2,0x87,0x7e,0xec,0x2f,
		0x63,0xb9,0x31,0xbd,0x47,0x41,0x7a,0x81,0xa5,0x38,0x32,0x7a,0xf9,0x27,0xda,0x3e}, 
		/*TST_SHA512_Expeced_dataSize*/
		CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
		CRYS_HASH_SHA1_mode
	},
#endif    
#if TST_USE_HASH_16BYTE_DATA
    { 
        {"Acceptance test x.0 - HASH/16ByteData "},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        /*TST_input_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0x21,0x37,0xb5,0x3f,0xef,0x34,0xd0,0xd3,0x1e,0xc3,0x88,0xc3,0x96,0x6e,0xde,0x21,0x5f,0x50,0xd0,0x7b}, 
        /*TST_SAH1_expected_dataSize*/
        CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_MD5_Expected_output_data*/
        {0xf2,0xec,0xfb,0x66,0xe7,0x2f,0x88,0xf2,0x17,0xe6,0x59,0xac,0x75,0xb1,0x07,0x5f}, 
        /*TST_MD5_Expeced_dataSize*/
        CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),       
        /*TST_SHA224_Expected_output_data*/
        {0xcc,0x8c,0x51,0x30,0x25,0xf9,0xc6,0x56,0x41,0xd1,0x67,0x6a,0x72,0x0a,0x6e,0x8b,
         0x46,0x95,0xfa,0xf6,0x69,0x1b,0x14,0x6a,0xa6,0x55,0x5e,0x58}, 
        /*TST_SHA224_Expeced_dataSize*/
        CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA256_Expected_output_data*/
        {0xa0,0x63,0xdf,0x83,0xa8,0xc2,0x8a,0x49,0xda,0xf4,0xae,0xba,0x0e,0x29,0xee,0x7b,
         0x21,0x77,0xe8,0x51,0x10,0x72,0x94,0x4c,0x3d,0x29,0x9c,0xf7,0x7d,0xc8,0x3e,0x7a}, 
        /*TST_SHA256_Expeced_dataSize*/
        CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA384_Expected_output_data*/
        {0x09,0x61,0xbb,0x6b,0xe5,0xc7,0xe8,0x96,0xaf,0x1a,0x57,0xb8,0xfd,0x0f,0x37,0xdd,
        0xa0,0xc9,0x87,0x04,0x5d,0x2a,0x8d,0x4c,0x8c,0x8c,0x80,0x80,0x9f,0x5b,0x10,0x0e,
        0x36,0xb6,0xa3,0xdf,0x84,0x4d,0x19,0x28,0xa0,0x2f,0x61,0x8c,0x00,0x62,0x78,0x88}, 
        /*TST_SHA384_Expeced_dataSize*/
        CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA512_Expected_output_data*/
        {0xa6,0x22,0x4e,0x2a,0xbe,0x3f,0x00,0x6f,0x53,0x43,0x4c,0xea,0x03,0x38,0xe9,0xd8,
        0xea,0x29,0xb6,0x37,0xb0,0x43,0x16,0x06,0x9c,0x7d,0x85,0xd2,0xeb,0x7b,0x94,0x02,
        0x81,0xd5,0x9c,0x91,0xe1,0xa8,0x0e,0x21,0xbb,0xb2,0x42,0x93,0x10,0x87,0x33,0x01,
        0x2b,0x3a,0xfe,0x9b,0x65,0x13,0x49,0x9f,0xd9,0xb4,0x7b,0xc9,0xea,0xc9,0x71,0xb6}, 
        /*TST_SHA512_Expeced_dataSize*/
        CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CRYS_HASH_SHA1_mode
    },
    #endif
    #if TST_USE_HASH_32BYTE_DATA
    { 
        {"Acceptance test x.0 - HASH/32ByteData "},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x65,0xa2,0x32,0xd6,0xbc,0xd0,0xf9,0x39,0xed,0x1f,0xe1,0x28,0xc1,0x3b,0x0e,0x1b},
        /*TST_input_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0x9f,0x9d,0xa1,0x0e,0xc2,0x37,0x35,0x93,0x00,0x89,0xa8,0xf8,0x9b,0x34,0xf7,0xb5,0xd2,0x67,0x90,0x3e}, 
        /*TST_SAH1_expected_dataSize*/
        CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_MD5_Expected_output_data*/
        {0x6c,0xe1,0xe1,0xe4,0x92,0x2d,0x54,0x93,0xda,0x8b,0x54,0x7b,0xbc,0xfa,0xfa,0x48}, 
        /*TST_MD5_Expeced_dataSize*/
        CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA224_Expected_output_data*/
        {0x68,0xab,0xe3,0x4d,0x09,0xa7,0x58,0xbe,0x6b,0x2f,0xb3,0xa7,0xa9,0x97,0x98,0x3a,
        0x63,0x96,0x87,0x09,0x9d,0x35,0x40,0x6f,0x92,0x7a,0x5c,0xc5}, 
        /*TST_SHA224_Expeced_dataSize*/
        CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA256_Expected_output_data*/
        {0x75,0xcf,0xb3,0x9b,0x62,0xc4,0x74,0x92,0x1e,0x2a,0xad,0x97,0x9c,0x21,0x0f,0x8b,
        0x69,0x18,0x0a,0x9d,0x58,0xe9,0xf2,0x96,0xa4,0xb9,0x90,0x4a,0xe6,0xe7,0xaa,0x40}, 
        /*TST_SHA256_Expeced_dataSize*/
        CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA384_Expected_output_data*/
        {0xbb,0x29,0xf8,0x63,0xaa,0x1b,0x4e,0x83,0xb6,0xd7,0xda,0x9a,0x7f,0x83,0x85,0xa0,
        0x01,0x1c,0xe5,0xf5,0x38,0x70,0xfc,0xf2,0xd5,0x53,0x92,0x14,0x3e,0xcd,0x4a,0x66,
        0x0b,0x54,0x79,0xd4,0x3e,0x8b,0x7b,0x02,0x73,0x55,0x3c,0xc6,0xd7,0x85,0x26,0xa4}, 
        /*TST_SHA384_Expeced_dataSize*/
        CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA512_Expected_output_data*/
        {0xe3,0x97,0x9c,0x62,0x96,0xe2,0x82,0xaf,0x04,0x61,0x99,0x92,0xf7,0x1a,0xdd,0xfe,
        0xfd,0x11,0x8b,0xe2,0x66,0x26,0xce,0xdd,0x71,0x5e,0xdc,0xed,0x36,0xb8,0x70,0x58,
        0xf8,0x68,0xb3,0x16,0xe7,0x25,0xb2,0x4e,0x1e,0x7f,0x66,0x1c,0xe2,0x93,0x5e,0x44,
        0xba,0x4d,0xee,0xa6,0x2a,0xfa,0x3e,0x13,0x18,0x80,0x71,0x40,0x3a,0x2f,0x14,0x63}, 
        /*TST_SHA512_Expeced_dataSize*/
        CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CRYS_HASH_SHA1_mode
    },
    #endif
    #if TST_USE_HASH_512BYTE_DATA
    { 
        {"Acceptance test x.0 - HASH/512ByteData "},
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        /*TST_input_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0x71,0x1c,0xc0,0xb0,0xb2,0x25,0x9b,0x2d,0xc5,0xa2,0x7a,0x0a,0xe2,0xb8,0xe5,0xe7,0x06,0xf9,0x10,0xe2}, 
        /*TST_SAH1_expected_dataSize*/
        CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_MD5_Expected_output_data*/
        {0x1a,0x47,0x78,0xcc,0x1a,0x8b,0xd3,0x8f,0x41,0x37,0x76,0x81,0x7a,0x0b,0x66,0x34}, 
        /*TST_MD5_Expeced_dataSize*/
        CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),   
        /*TST_SHA224_Expected_output_data*/
        {0xb2,0x56,0xd5,0x49,0xf9,0x2e,0x66,0x90,0x0f,0x54,0x9e,0xf0,0x7c,0x86,0xe4,0x03,
        0xb8,0x9e,0xe4,0xf2,0x4c,0xcb,0x97,0xc4,0xe4,0x0a,0xa2,0xd6}, 
        /*TST_SHA224_Expeced_dataSize*/
        CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA256_Expected_output_data*/
        {0xf0,0xc1,0x39,0x0c,0xff,0xca,0x99,0xce,0x51,0x40,0x1a,0x16,0x07,0x64,0x66,0xfb,
        0x88,0xfe,0x45,0x58,0xe7,0xe7,0x06,0x6b,0x7d,0xad,0x7b,0x11,0x1f,0xa6,0x49,0x83}, 
        /*TST_SHA256_Expeced_dataSize*/
        CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA384_Expected_output_data*/
        {0x5d,0xfb,0x7b,0xc9,0xc8,0xc9,0xd2,0x68,0xfb,0x66,0xec,0x8b,0xa3,0x58,0xfb,0x6b,
        0xc1,0x81,0x1d,0xf7,0x0b,0x27,0x31,0x73,0x30,0x87,0x5b,0x2e,0x8b,0xd2,0x8c,0xc2,
        0x20,0x34,0x6e,0x7f,0x6b,0x0b,0xc8,0x25,0x41,0x20,0xb5,0x25,0x44,0xb9,0x06,0xd7}, 
        /*TST_SHA384_Expeced_dataSize*/
        CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA512_Expected_output_data*/
        {0xb6,0x1c,0xcb,0x60,0x3b,0x61,0x58,0x91,0x81,0x9b,0xd3,0x35,0x36,0x71,0x04,0xe5,
        0x99,0xb2,0xc9,0x13,0xad,0x8a,0xc3,0x5b,0x7b,0xee,0x0a,0xe0,0x8a,0x1a,0x2f,0x2a,
        0x3d,0x3d,0x06,0xce,0xe4,0x4b,0x52,0x91,0xf7,0x15,0xf2,0x4e,0x45,0x1c,0x81,0x7e,
        0x4c,0x9b,0xd2,0xeb,0x09,0x43,0x2f,0xdc,0x7e,0x4a,0x72,0xab,0x6e,0x3d,0xe3,0xad}, 
        /*TST_SHA512_Expeced_dataSize*/
        CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CRYS_HASH_SHA1_mode
    },
    #endif
    #if TST_USE_HASH_1536BYTE_DATA
    { 
        {"Acceptance test x.0 - HASH/1536ByteData "},
        /*TST_input_data*/
        {0xc6,0x4c,0xab,0x69,0x8b,0x3f,0x48,0x72,0x11,0x0f,0xf6,0x4d,0x11,0x9b,0xe8,0xf0,
        0xf9,0xaf,0x8d,0xa1,0x49,0xd6,0x12,0x67,0x3d,0x6f,0x28,0xbe,0xac,0x03,0x07,0x8e,
        0x30,0xd6,0xb3,0x5e,0x87,0xbc,0x7e,0xc5,0x39,0x2e,0xce,0x22,0x7b,0x9d,0x20,0x8d,
        0x54,0x06,0x4d,0x0e,0xfe,0xc7,0x0c,0x0c,0x8f,0xb1,0xb9,0x08,0xd9,0x5e,0x55,0x8b,
        0x8e,0xc5,0xcd,0x5c,0xa8,0x0b,0x7f,0xf7,0x07,0x9d,0xfa,0x3b,0x5c,0x7b,0x05,0x63,
        0x47,0xd7,0xe4,0x37,0xbc,0xde,0xd6,0x83,0xab,0xd6,0xe2,0xc9,0xe0,0x69,0xd3,0x33,
        0x28,0x40,0x82,0xcb,0xb5,0xd4,0x53,0xee,0xc3,0x81,0x02,0xfe,0x7c,0xdd,0xa0,0x58,
        0x19,0x47,0xd8,0x86,0x4b,0xc3,0x77,0xb5,0xd9,0x05,0x2c,0x69,0x8a,0xcb,0x8b,0x6f,
        0x45,0x70,0x58,0x14,0x77,0xbe,0x03,0x94,0xb5,0x05,0x6f,0xd5,0xa3,0x69,0xf7,0x55,
        0x14,0x80,0xb3,0x61,0x72,0x1d,0xf7,0x89,0x61,0x66,0x1d,0x50,0x9f,0x2d,0x85,0x28,
        0x2e,0x7d,0xd9,0x9d,0xb6,0x72,0x96,0xd0,0x25,0x4e,0xc8,0x27,0x98,0xca,0x15,0x43,
        0x7e,0xaa,0xfc,0x32,0xfa,0x94,0x5f,0xe6,0x8a,0x22,0x3f,0xe6,0xe7,0x36,0xc8,0x44,
        0x2c,0x8e,0x8d,0xcf,0x39,0x98,0x14,0x89,0x5a,0x87,0x95,0x5c,0x24,0xa6,0xff,0x08,
        0xa0,0xec,0x3c,0x60,0xac,0xd1,0xb6,0xb6,0x9d,0x61,0x1a,0x94,0x29,0x8f,0x5c,0xad,
        0x85,0xcb,0xfb,0x12,0xca,0xd7,0x86,0xa9,0x9d,0xd6,0x5f,0xdc,0x0f,0xa6,0xbf,0x8e,
        0xc2,0x6f,0xfa,0x53,0x4e,0x7c,0x04,0xe0,0xe2,0x4a,0x34,0xc0,0x2f,0xdf,0x49,0x49,
        0x81,0x5d,0xab,0xcf,0x2f,0xd7,0xf3,0x17,0x36,0x63,0xac,0x0e,0x21,0x71,0x5b,0xbb,
        0x2c,0x5b,0xbe,0x73,0xa8,0x3d,0x52,0x4c,0xa1,0x06,0x17,0xd4,0xbf,0xcf,0x97,0x02,
        0x6a,0x6c,0x25,0x6c,0x31,0x41,0x63,0xbb,0x6d,0x57,0x07,0x5c,0x21,0xb0,0xde,0x79,
        0x25,0xd7,0x11,0x28,0x84,0xba,0xa7,0xe2,0x22,0xbc,0x4b,0x36,0xa2,0x07,0x4f,0xbe,
        0x86,0x1f,0xf2,0x53,0x98,0xbd,0xde,0x7d,0x89,0xda,0xf5,0x2d,0xd9,0x0a,0x4d,0xaf,
        0xf6,0x0b,0x79,0xda,0xa8,0x9e,0x0b,0x8a,0xac,0x95,0x56,0x50,0xa0,0x2e,0x79,0x67,
        0x1f,0x9f,0x99,0xea,0x2c,0xf2,0x6d,0x45,0xd4,0x13,0x00,0xea,0x0f,0x28,0xb2,0x45,
        0xe8,0x20,0x80,0xf1,0xdd,0x8f,0x86,0x2c,0x89,0xb9,0xc2,0x88,0x80,0xec,0x1b,0xe4,
        0x7b,0x14,0xa2,0x9b,0xb5,0x89,0x17,0xfb,0x94,0x2b,0xaf,0xf9,0x8c,0xb1,0x14,0x22,
        0x41,0x3e,0xae,0xd5,0xeb,0x35,0x21,0xb0,0xff,0x4f,0x17,0x48,0x0c,0xeb,0x3f,0x1d,
        0xe2,0xa5,0x96,0xcd,0xfa,0x29,0xe5,0x87,0x12,0x4a,0x8a,0xc3,0x18,0x4e,0x7c,0x30,
        0x49,0x8c,0x8a,0xee,0x9a,0x3a,0xe3,0xfe,0x57,0x80,0xdb,0xf7,0x0a,0xd0,0xec,0xfa,
        0x9e,0x7a,0xfb,0xe7,0xc4,0x7b,0xdd,0xd1,0x96,0x96,0x1a,0xb0,0x7a,0xa7,0xf1,0x56,
        0x4a,0x33,0x9c,0xa5,0xb2,0x43,0xd5,0xfe,0xd9,0x73,0x98,0xfc,0x43,0x46,0x2b,0x63,
        0xf6,0xbc,0x5c,0x53,0xdb,0x27,0x0a,0xc2,0x68,0x3a,0xe6,0x29,0x7c,0x63,0x7b,0x7c,
        0x8a,0x5b,0x6c,0x60,0xfa,0xfb,0xfd,0x99,0xcc,0x51,0xd5,0xc1,0x7f,0xf3,0x03,0x40,
        0x31,0x93,0x3e,0x78,0x07,0xd4,0x71,0x40,0xcf,0x5c,0x77,0x94,0xe4,0x2a,0x22,0x8a,
        0x52,0x2a,0x83,0x88,0x3b,0x07,0x65,0xb5,0x7a,0x41,0x1b,0xad,0x85,0x7f,0x7c,0x79,
        0x98,0x26,0x2b,0xbe,0x10,0x2a,0x1c,0x34,0x15,0x25,0x53,0x5a,0x7b,0xa6,0xef,0x69,
        0xea,0xcb,0x68,0x86,0x3d,0x12,0x15,0x3b,0x29,0x6c,0xf1,0x28,0x1f,0x93,0x9e,0xf6,
        0x73,0x9e,0xaa,0x8d,0xbd,0xd3,0x12,0x87,0x80,0xbc,0x04,0xe4,0x09,0x7d,0xe9,0xff,
        0x9a,0x64,0xa3,0xc0,0xc8,0xc2,0x13,0x14,0x22,0xf9,0xdf,0x9a,0x13,0xd7,0x72,0xa0,
        0x0a,0x22,0x44,0x4d,0xd7,0x74,0x5b,0x1f,0x59,0x49,0x12,0x99,0x56,0x57,0x19,0x35,
        0xaa,0x1e,0xbd,0xa0,0xa4,0xbf,0x69,0x26,0xad,0x11,0x6d,0x6b,0x2a,0xf2,0xff,0x5d,
        0xa4,0xdb,0x7f,0x66,0x26,0xb8,0x00,0xe6,0xe7,0xf6,0x03,0xe0,0x29,0xdd,0x85,0xf4,
        0x61,0x20,0x3d,0x8d,0x98,0xb2,0x1f,0x5b,0x11,0xdc,0x24,0x04,0x2c,0x8d,0x4d,0x16,
        0x8a,0xf1,0xe6,0x41,0x72,0x44,0x08,0xc3,0x74,0xe9,0x61,0x23,0x4c,0xb6,0x37,0x22,
        0x09,0x93,0xab,0xef,0x6e,0x43,0x3b,0x9a,0x98,0x81,0x8b,0xcb,0xe1,0x4f,0x65,0xb4,
        0x05,0x8b,0xfe,0x44,0x83,0xc3,0x7b,0x9d,0x46,0x4a,0xb3,0xc9,0x85,0x8b,0x37,0xa8,
        0xe8,0x9e,0x90,0x2d,0xec,0x19,0xc7,0xca,0x88,0x29,0x2b,0x29,0x11,0xe1,0x4e,0x1d,
        0x5b,0xd1,0x51,0xd8,0x21,0xdb,0x61,0x5e,0xa6,0x42,0x82,0x3a,0x9d,0x04,0x8b,0x6f,
        0x46,0x6a,0x72,0xb1,0xdb,0xdd,0xca,0xd5,0x2a,0xfb,0x8a,0x87,0x83,0xea,0x10,0x3b,
        0xd4,0xec,0x66,0x66,0x13,0x34,0xc3,0xed,0xdc,0xf9,0x55,0xdd,0x5c,0xc8,0x3d,0x5e,
        0x6d,0x1e,0xdc,0xe2,0x02,0x36,0x4d,0xa2,0xc6,0x20,0x32,0x4b,0x00,0x13,0xb4,0xf4,
        0xba,0x04,0xc5,0x54,0x22,0x77,0xa8,0x32,0x30,0x96,0xb4,0x1c,0x89,0x80,0x55,0x5c,
        0xa4,0xe3,0x53,0x28,0x2b,0xcd,0x57,0x19,0xa4,0xbf,0xab,0xdf,0x50,0x04,0x41,0x32,
        0x53,0x40,0xf7,0x0b,0x16,0x4c,0x19,0x15,0xea,0x41,0x27,0x5e,0xee,0xd3,0xd9,0x53,
        0x32,0xe1,0x61,0xeb,0x1c,0x49,0xf0,0x22,0x0b,0x01,0x7b,0xa9,0x3b,0x64,0xbf,0xdc,
        0xe9,0xc9,0x83,0xf4,0xb7,0x5a,0x1d,0x7e,0x51,0x24,0x37,0x0c,0x51,0x6a,0xd3,0x2a,
        0x60,0x3f,0x8d,0x93,0x9e,0x54,0x20,0xa5,0x45,0x0e,0x2c,0x13,0x89,0xdb,0x37,0xda,
        0xc2,0xc7,0xf1,0x76,0xcc,0x4a,0xbc,0x55,0xae,0x64,0x6b,0x8c,0x7b,0xec,0x4a,0xc9,
        0x76,0x26,0x5f,0x88,0x79,0x93,0xf0,0x8a,0x98,0x0d,0x46,0x83,0x01,0x13,0xb0,0x14,
        0x26,0x61,0xca,0xf8,0x1f,0xc3,0xfe,0x82,0x49,0x2c,0x4c,0x47,0x34,0x02,0x47,0x18,
        0xbc,0xbd,0x60,0x33,0x75,0xb0,0x67,0xb9,0x4d,0x26,0x4f,0x63,0x6c,0xb1,0x32,0x71,
        0x5f,0xbf,0x94,0xe4,0x76,0x6e,0xec,0xed,0x6a,0xa2,0x61,0xa5,0x43,0x54,0xd1,0xfe,
        0x79,0x2d,0x17,0xfa,0x5a,0x53,0x8e,0x1b,0xab,0x83,0xd1,0x1a,0x92,0x60,0xc5,0xdc,
        0xb4,0x0a,0xda,0xa1,0x9a,0xf3,0x8d,0x7f,0x59,0xee,0x32,0x0f,0x72,0x89,0xf0,0x66,
        0xf7,0x9d,0x0d,0x46,0xef,0x23,0x6b,0x96,0xfc,0x49,0x53,0x10,0x3b,0xc6,0x72,0x3a,
        0x6c,0x6a,0x21,0x97,0x53,0xf9,0xea,0x1e,0x5d,0x39,0x47,0xeb,0x87,0x4a,0xac,0x35,
        0x7c,0x36,0xc8,0x80,0xfd,0xc9,0x09,0x13,0x86,0xa3,0x5e,0xad,0x2f,0x8b,0x40,0x74,
        0xd0,0x06,0xf3,0x2e,0x68,0x28,0x09,0xb3,0xc0,0xab,0x29,0xa2,0x4b,0x3e,0x0e,0x54,
        0x51,0x1f,0xd2,0x0e,0x4c,0xec,0x6d,0x7b,0x93,0xb7,0x79,0x59,0x35,0x58,0x38,0x72,
        0x28,0x07,0xd7,0xce,0xa3,0x2a,0xf4,0x27,0xc8,0x6b,0x5f,0x9d,0x86,0x0e,0x1d,0xab,
        0xbe,0x81,0xb3,0x5a,0xa4,0x35,0xa1,0xb4,0x69,0xad,0x2c,0x7c,0x17,0xd5,0x60,0x1c,
        0xbc,0x94,0x56,0xdf,0xca,0xa4,0xb3,0x60,0xbe,0xa2,0x71,0x43,0x00,0x61,0xe2,0x22,
        0x0a,0x84,0xf1,0xca,0xcd,0x4c,0xac,0xa8,0x50,0xae,0xff,0x7e,0x9b,0xa9,0xc2,0x5a,
        0xd3,0xd6,0xf7,0xc9,0xa6,0x41,0x4c,0x48,0xea,0x77,0xe8,0xfb,0x80,0xe0,0x63,0xa2,
        0x7f,0x4f,0x16,0xc8,0x8e,0xd8,0x96,0x3d,0x92,0xe2,0x7b,0xc7,0x8a,0x7c,0x66,0x15,
        0xb6,0xf5,0x42,0xf4,0xff,0xa6,0xc9,0xc6,0x93,0x13,0x4a,0x2f,0xd0,0x33,0xaa,0x11,
        0x63,0x0b,0xaa,0xbb,0xb1,0x82,0x67,0x5d,0x76,0x70,0x27,0xbf,0xab,0xf8,0x52,0x33,
        0xae,0x18,0xbf,0xc9,0x9d,0x7e,0x31,0xc1,0x02,0x9d,0x22,0x46,0xb6,0x01,0xbf,0x59,
        0xff,0xdf,0x33,0x0b,0xfc,0xf1,0x28,0xef,0x43,0x80,0x8b,0xcf,0xc8,0xc3,0x90,0x9e,
        0x01,0x67,0xf7,0xae,0x47,0x6f,0x8d,0x23,0x80,0x3e,0xf5,0xa8,0xfb,0xf2,0xa8,0x60,
        0x9b,0xf4,0x3b,0x1f,0x38,0xcd,0xe1,0xdb,0x42,0x3c,0x30,0x5d,0xa7,0x85,0x28,0x3c,
        0xf7,0x0b,0x71,0x0c,0xc7,0x21,0xe4,0xd3,0x53,0x1e,0x4d,0xbc,0x67,0xaf,0x6f,0x10,
        0x7f,0x72,0x49,0x61,0x2d,0xc0,0x98,0x09,0xbb,0xca,0x9d,0xd3,0x11,0xe7,0x20,0xf7,
        0xda,0x2c,0xb5,0x4c,0xe3,0x3e,0x3e,0xb9,0xc3,0x64,0xb1,0xec,0xc1,0xe0,0x1c,0x4f,
        0xf2,0x80,0xe6,0x38,0xa2,0x70,0x57,0x61,0xf5,0x52,0x5a,0x97,0xce,0x90,0x82,0xb6,
        0xf0,0xf1,0x4c,0xd4,0x64,0x6b,0xa4,0xbd,0x1a,0x39,0xaa,0xa0,0xd3,0x2d,0xb5,0x07,
        0x3d,0x46,0x98,0x0c,0x60,0x85,0x25,0xca,0x3a,0xfd,0xf0,0x13,0xa6,0x2a,0x56,0x61,
        0x83,0x83,0xbd,0x0e,0x11,0x52,0x1c,0xc7,0x9e,0xc4,0xbf,0x3e,0x63,0x3c,0x44,0x1f,
        0xa9,0xed,0xea,0x46,0x30,0xa8,0x0b,0x2f,0xd0,0xf2,0xe6,0xad,0x61,0x5a,0xa2,0xdf,
        0xd9,0x0a,0x90,0x60,0xb4,0x9b,0xb1,0xbf,0x99,0x2e,0x78,0x2f,0x3a,0xb8,0xd0,0x7f,
        0x7c,0x9d,0x61,0x4c,0xd8,0x81,0x0f,0x75,0x00,0x5a,0xc4,0xcf,0xc6,0xca,0x70,0x1a,
        0x3a,0xad,0x4e,0x34,0x13,0xee,0x68,0x8d,0x51,0x9e,0x5d,0xdb,0x20,0x47,0x62,0x0f,
        0xfe,0x7d,0x87,0x87,0x20,0xb7,0x3c,0x85,0x12,0x5d,0x13,0xe0,0x9f,0x22,0xc7,0xf9,
        0xf0,0x94,0x7e,0xf1,0xf8,0xf1,0x4b,0x19,0x0f,0x3d,0xf7,0xaa,0xdc,0x91,0x01,0xb7,
        0x79,0xb6,0xe3,0x5f,0xd2,0xf3,0x97,0x47,0x4e,0x22,0x5a,0x48,0xb2,0x09,0xb0,0x64,
        0x42,0xe8,0xa8,0xff,0x29,0x4f,0x61,0x4b,0x1a,0x32,0xcd,0x05,0x38,0x3f,0xb5,0x5f,
        0x33,0x6f,0xfd,0x3d,0xb4,0xdc,0x2a,0xa3,0xfc,0xd2,0x21,0x6e,0xc8,0x28,0x31,0x43},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0xeb,0xc1,0x56,0xa7,0x02,0xf6,0x65,0xeb,0x27,0xa0,0x6b,0x11,0x72,0xdf,0x63,0x65,0x8c,0x63,0x26,0x1d}, 
        /*TST_SAH1_expected_dataSize*/
        CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_MD5_Expected_output_data*/
        {0x42,0x9d,0x35,0x1b,0x89,0xe2,0x85,0xf0,0x28,0x1c,0x95,0x61,0x37,0x2c,0xca,0x5d}, 
        /*TST_MD5_Expeced_dataSize*/
        CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA224_Expected_output_data*/
        {0x79,0x61,0x03,0x6f,0x62,0xf4,0xa8,0x31,0x83,0xe3,0xe7,0xc4,0x2b,0x5a,0x14,0xaa,
        0x86,0x3f,0x47,0x86,0x34,0xc1,0x1e,0xdc,0x5d,0xc1,0x2b,0xd3}, 
        /*TST_SHA224_Expeced_dataSize*/
        CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA256_Expected_output_data*/
        {0x1a,0x21,0x43,0xc5,0xbe,0xa9,0xf4,0xa0,0x46,0x29,0xa1,0x47,0xbc,0xe4,0x30,0x4a,
        0x67,0xbd,0xab,0xa3,0x15,0x50,0xac,0x99,0x9f,0x82,0xba,0xc5,0xd8,0xa7,0x9c,0x9e}, 
        /*TST_SHA256_Expeced_dataSize*/
        CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA384_Expected_output_data*/
        {0xf2,0x06,0x17,0x51,0xa4,0xf6,0xf5,0x18,0x53,0xb0,0x8b,0xa1,0xfc,0x51,0x38,0x21,
        0xe8,0xdd,0xd2,0x7f,0x40,0x5a,0x1f,0x0e,0x6b,0xc9,0x27,0xf8,0x45,0xa6,0xdd,0x9a,
        0x7b,0x14,0xe7,0x0a,0x33,0x64,0xaa,0x1e,0xfa,0x39,0x74,0xd1,0x1f,0x8a,0x73,0x2d}, 
        /*TST_SHA384_Expeced_dataSize*/
        CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA512_Expected_output_data*/
        {0x4f,0xd5,0x8d,0xfe,0xec,0x48,0x1f,0x1c,0xf8,0xd3,0xb9,0x29,0x34,0x99,0x4f,0x04,
        0x81,0xac,0xda,0xcd,0xca,0x92,0x1f,0x13,0x23,0xe4,0x55,0x35,0x2e,0x71,0xdf,0xf1,
        0xaa,0x61,0xb3,0x56,0xa7,0xa5,0x22,0x44,0xb9,0x37,0xf3,0x08,0x68,0x98,0x95,0x69,
        0x62,0xf9,0xc6,0x76,0x35,0xdc,0x0a,0x93,0xe1,0x9c,0x53,0x0e,0x4a,0x4c,0x6d,0xde}, 
        /*TST_SHA512_Expeced_dataSize*/
        CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CRYS_HASH_SHA1_mode
    },
    #endif
};

const int TST_NumberOfHASHAcceptanceTests = sizeof(TST_HASH_Acceptance_TestData)/sizeof(TST_HASH_Acceptance_TestData[0]);
#endif


